/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.client.screen.basic.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.sixik.sdmshoprework.SDMShopR;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryType;
import net.sixik.sdmshoprework.api.shop.AbstractShopTab;
import net.sixik.sdmshoprework.client.screen.basic.AbstractShopScreen;
import net.sixik.sdmshoprework.client.screen.legacy.buyer.LegacyBuyerScreen;
import net.sixik.sdmshoprework.common.shop.ShopBase;
import net.sixik.sdmshoprework.common.shop.ShopEntry;
import net.sixik.sdmshoprework.common.shop.ShopTab;
import net.sixik.sdmshoprework.common.shop.type.ShopItemEntryType;
import net.sixik.sdmshoprework.common.utils.ListHelper;
import net.sixik.sdmshoprework.common.utils.TypeCreator;
import net.sixik.sdmshoprework.network.server.SendChangesShopEntriesC2S;
import net.sixik.sdmshoprework.network.server.edit.SendEditShopEntryC2S;
import net.sixik.sdmshoprework.network.server.move.SendMoveShopEntryC2S;

public abstract class AbstractShopEntryButton
extends SimpleTextButton {
    public AbstractShopEntry entry;
    public boolean isEdit = false;

    public AbstractShopEntryButton(Panel panel, AbstractShopEntry entry) {
        super(panel, (Component)Component.m_237119_(), (Icon)(entry == null ? Color4I.EMPTY : entry.getEntryType().getIcon()));
        this.entry = entry;
    }

    public void addMouseOverText(TooltipList list) {
        if (this.entry != null && this.entry.getEntryType() != null) {
            AbstractShopEntryType abstractShopEntryType = this.entry.getEntryType();
            if (abstractShopEntryType instanceof ShopItemEntryType) {
                ShopItemEntryType entryType = (ShopItemEntryType)abstractShopEntryType;
                ArrayList list1 = new ArrayList();
                GuiHelper.addStackTooltip((ItemStack)entryType.itemStack, list1);
                list1.forEach(arg_0 -> ((TooltipList)list).add(arg_0));
            } else if (!this.entry.title.isEmpty()) {
                list.add((Component)Component.m_237115_((String)this.entry.title));
            }
            if (!this.entry.descriptionList.isEmpty()) {
                list.add((Component)Component.m_237119_());
                this.entry.descriptionList.stream().map(Component::m_237115_).forEach(arg_0 -> ((TooltipList)list).add(arg_0));
            }
        }
    }

    public void onClicked(MouseButton mouseButton) {
        try {
            if (mouseButton.isLeft()) {
                if (this.isEdit) {
                    List<ContextMenuItem> contextMenu = TypeCreator.createContext(this.getShopScreen());
                    this.getShopScreen().openContextMenu(contextMenu);
                    return;
                }
                if (Screen.m_96637_() && SDMShopR.isEditMode()) {
                    if (this.getShopScreen().selectedEntryID == null) {
                        this.getShopScreen().selectedEntryID = this.entry.entryUUID;
                    } else if (Objects.equals(this.getShopScreen().selectedEntryID, this.entry.entryUUID)) {
                        this.getShopScreen().selectedEntryID = null;
                    } else {
                        ListHelper.swap(this.entry.getShopTab().getTabEntry(), this.entry.getShopTab().getShopEntry(this.getShopScreen().selectedEntryID).getIndex(), this.entry.getIndex());
                        new SendMoveShopEntryC2S(this.entry.getShopTab().shopTabUUID, this.entry.getShopTab().getShopEntry(this.getShopScreen().selectedEntryID).getIndex(), this.entry.getIndex()).sendToServer();
                        this.getShopScreen().selectedEntryID = null;
                        this.getShopScreen().refreshWidgets();
                    }
                } else if (Screen.m_96638_() && SDMShopR.isEditMode()) {
                    if (this.entry.getEntryType().getSellType() == AbstractShopEntryType.SellType.BOTH) {
                        this.entry.isSell = !this.entry.isSell;
                        new SendChangesShopEntriesC2S(this.getShopScreen().selectedTab.shopTabUUID, ShopBase.CLIENT.getShopTab(this.getShopScreen().selectedTab.shopTabUUID).serializeNBT()).sendToServer();
                        this.getShopScreen().refreshWidgets();
                    }
                } else {
                    this.openBuyScreen();
                    this.getShopScreen().refreshWidgets();
                }
            }
            if (mouseButton.isRight() && SDMShopR.isEditMode() && !this.isEdit) {
                ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
                contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"sdm.shop.entry.context.edit"), Icons.SETTINGS, () -> {
                    ConfigGroup group = new ConfigGroup("sdmr").setNameKey("sidebar_button.sdmr.shop");
                    group.savedCallback = s -> {
                        if (s) {
                            new SendEditShopEntryC2S(this.entry.getShopTab().shopTabUUID, this.entry.entryUUID, this.entry.serializeNBT()).sendToServer();
                            this.getShopScreen().refreshWidgets();
                        }
                        this.openGui();
                    };
                    ConfigGroup g = group.getGroup("shop").getGroup("entry");
                    this.entry.getConfig(g);
                    new EditConfigScreen(group).openGui();
                    this.getShopScreen().refreshWidgets();
                }));
                contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"sdm.shop.entry.context.duplicate"), Icons.ADD, () -> {
                    ShopTab tab = ShopBase.CLIENT.getShopTab(this.entry.getShopTab().shopTabUUID);
                    AbstractShopEntry patt6076$temp = this.entry;
                    if (patt6076$temp instanceof ShopEntry) {
                        ShopEntry shopEntry = (ShopEntry)patt6076$temp;
                        ShopEntry d = shopEntry.copy();
                        tab.getTabEntry().add(d);
                        this.entry.getShopTab().getTabEntry().add(d);
                    }
                    new SendChangesShopEntriesC2S(this.getShopScreen().selectedTab.shopTabUUID, ShopBase.CLIENT.getShopTab(this.getShopScreen().selectedTab.shopTabUUID).serializeNBT()).sendToServer();
                    this.getShopScreen().refreshWidgets();
                }));
                contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"sdm.shop.entry.context.delete"), Icons.REMOVE, () -> {
                    ShopTab tab = ShopBase.CLIENT.getShopTab(this.entry.getShopTab().shopTabUUID);
                    this.entry.getShopTab().removeEntry(this.entry.entryUUID);
                    tab.removeEntry(this.entry.entryUUID);
                    new SendChangesShopEntriesC2S(this.getShopScreen().selectedTab.shopTabUUID, ShopBase.CLIENT.getShopTab(this.getShopScreen().selectedTab.shopTabUUID).serializeNBT()).sendToServer();
                    this.getShopScreen().refreshWidgets();
                }));
                contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"sdm.shop.entry.context.move.up"), Icons.UP, () -> {
                    this.moneEntry(true);
                    this.getShopScreen().refreshWidgets();
                }));
                contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"sdm.shop.entry.context.move.down"), Icons.DOWN, () -> {
                    this.moneEntry(false);
                    this.getShopScreen().refreshWidgets();
                }));
                this.getShopScreen().openContextMenu(contextMenu);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void openBuyScreen() {
        new LegacyBuyerScreen(this.entry).openGui();
    }

    public AbstractShopEntryButton setEdit() {
        this.isEdit = true;
        this.icon = Icons.ADD;
        return this;
    }

    public AbstractShopScreen getShopScreen() {
        return (AbstractShopScreen)this.getGui();
    }

    public void moneEntry(boolean isUp) {
        int entryId = this.entry.getIndex();
        ShopTab tab = ShopBase.CLIENT.getShopTab(this.entry.getShopTab().shopTabUUID);
        AbstractShopTab d1 = this.entry.getShopTab();
        if (isUp) {
            ListHelper.moveUp(d1.getTabEntry(), entryId);
            ListHelper.moveUp(tab.getTabEntry(), entryId);
        } else {
            ListHelper.moveDown(d1.getTabEntry(), entryId);
            ListHelper.moveDown(tab.getTabEntry(), entryId);
        }
        new SendChangesShopEntriesC2S(this.getShopScreen().selectedTab.shopTabUUID, ShopBase.CLIENT.getShopTab(this.getShopScreen().selectedTab.shopTabUUID).serializeNBT()).sendToServer();
    }

    public boolean isSelected() {
        return this.getShopScreen().selectedEntryID != null && this.entry != null && Objects.equals(this.getShopScreen().selectedEntryID, this.entry.entryUUID);
    }

    public void drawSelected(PoseStack graphics, int x, int y, int w, int h) {
        GuiHelper.drawHollowRect((PoseStack)graphics, (int)x, (int)y, (int)w, (int)h, (Color4I)Color4I.WHITE, (boolean)false);
    }
}

